#ifndef SIGNALS_H
#define SIGNALS_H

#include "gnome-radio-signals-crypto.h"

typedef struct {
    KeyPair keypair;
    unsigned char peer_pub[crypto_box_PUBLICKEYBYTES];
} SignalsConnection;

int init_signals(SignalsConnection *conn);
int send_message(SignalsConnection *conn, const char *msg);
int receive_message(SignalsConnection *conn, const unsigned char *cipher, unsigned long long len, const unsigned char *nonce, char *msg);

#endif
