#ifndef CRYPTO_H
#define CRYPTO_H

#include <sodium.h>

typedef struct {
    unsigned char public_key[crypto_box_PUBLICKEYBYTES];
    unsigned char secret_key[crypto_box_SECRETKEYBYTES];
} KeyPair;

int crypto_init();
int generate_keypair(KeyPair *kp);
int encrypt_message(const unsigned char *msg, unsigned long long msg_len,
                    const unsigned char *receiver_pub,
                    const unsigned char *sender_secret,
                    unsigned char *cipher, unsigned char *nonce);
int decrypt_message(const unsigned char *cipher, unsigned long long cipher_len,
                    const unsigned char *nonce,
                    const unsigned char *sender_pub,
                    const unsigned char *receiver_secret,
                    unsigned char *msg);

#endif
