Name:           gnome-radio
Version:        63.0
Release:        1%{?dist}
Summary:        Radio
License:        GPLv3+
URL:            http://www.gnomeradio.org/
Source:         %{url}/src/%{name}-%{version}.tar.xz

BuildRequires:  gcc
BuildRequires:  gtk3-devel
BuildRequires:  pango
BuildRequires:  libchamplain-devel
BuildRequires:  libxml2-devel
BuildRequires:  intltool
BuildRequires:  itstool
BuildRequires:  libappstream-glib
BuildRequires:  desktop-file-utils
BuildRequires:  geoclue2-devel
BuildRequires:  geocode-glib-devel
BuildRequires:  gstreamer1-devel
BuildRequires:  gstreamer1-plugins-bad-free-devel
BuildRequires:  gstreamer1-plugins-base-devel
Requires:       gstreamer1 >= 1.8.3
Requires:       gstreamer1-plugins-ugly-free >= 1.8.3
Requires:       geocode-glib >= 3.20.1
Requires:       gtk3 >= 3.24.34
Requires:       geoclue2 >= 2.5.7
Provides:       gnome-internet-radio-locator = 16.0.6
Obsoletes:      gnome-internet-radio-locator < 16.0.6
Provides:       gtk-radio = 550.3
Obsoletes:      gtk-radio < 550.3

%description

Radio is a Free Software program that allows you to easily locate Free
Internet Radio stations by broadcasters on the Internet with the help
of map and text search.

Radio is developed on the GNOME desktop platform.

Radio supports Public Radio (www.npr.org) in USA.

%prep
%setup -q

%build
%configure --with-recording --disable-silent-rules --disable-schemas
%make_build
%install
%make_install
%find_lang %{name} --with-man

%check
appstream-util validate-relax --nonet %{buildroot}%{_metainfodir}/%{name}.appdata.xml
desktop-file-validate %{buildroot}/%{_datadir}/applications/%{name}.desktop
%files -f %{name}.lang
%doc AUTHORS NEWS README TODO ChangeLog
%license COPYING
%{_bindir}/%{name}
%{_bindir}/gnome-internet-radio-locator
%{_bindir}/gtk-radio
%{_bindir}/gtk-internet-radio-locator
%{_bindir}/org.gnome.Radio
%{_bindir}/radio-icy
%{_datadir}/%{name}/org.gnome.Radio.dtd
%{_datadir}/%{name}/org.gnome.Radio.xml
%{_datadir}/%{name}/doc/AAMOT.txt.xz
%{_datadir}/%{name}/doc/Aamot-2020.txt.xz
%{_datadir}/%{name}/gnome-radio-48.0.dtd
%{_datadir}/%{name}/gnome-radio.xml
%{_metainfodir}/%{name}.appdata.xml
%{_datadir}/applications/%{name}.desktop
%{_datadir}/gtk-radio/gtk-radio-550.3.dtd
%{_datadir}/gtk-radio/gtk-radio.xml
%{_datadir}/gtk-internet-radio-locator/internet-radio-locator-48.0.dtd
%{_datadir}/gtk-internet-radio-locator/internet-radio-locator.xml
%{_datadir}/icons/hicolor/scalable/apps/gnome-radio.svg
%{_mandir}/man1/%{name}.1*

%changelog
* Tue Dec 23 2025 Ole Aamot <ole@aamot.org> - 63.0-1
- Stable gnome-radio 63.0 with Free World Radio (Greenland)

* Mon Dec 08 2025 Ole Aamot <ole@aamot.org> - 62.0-1
- Stable gnome-radio 62.0 with World Wide Talk Radio

* Wed Oct 29 2025 Ole Aamot <ole@aamot.org> - 60.0-1
- Stable gnome-radio 60.0 with World Wide Live Radio

* Wed Oct 15 2025 Ole Aamot <ole@aamot.org> - 59.0-1
- Stable gnome-radio 59.0 with Free Internet Talk Radio (ARPANET)

* Wed Oct 08 2025 Ole Aamot <ole@aamot.org> - 58.0-1
- Stable gnome-radio 58.0 with BBC World Service (World Wide Web)

* Wed Oct 01 2025 Ole Aamot <ole@aamot.org> - 57.0-1
- Stable gnome-radio 57.0 with Radio Norwegian (Norway)

* Fri Sep 12 2025 Ole Aamot <ole@aamot.org> - 56.0-1
- Stable gnome-radio 56.0 with BBC World Service (United Kingdom)

* Wed Sep 10 2025 Ole Aamot <ole@aamot.org> - 52.0-1
- Stable gnome-radio 52.0 with Radio Warszawa (Warszawa, Poland)

* Sun Aug 10 2025 Ole Aamot <ole@aamot.org> - 51.0-1
- Stable gnome-radio 51.0 with Gudbrandsdalsradioen (Vinstra, Norway) and Elverumsradioen (Elverum, Norway)

* Sun Jul 27 2025 Ole Aamot <ole@aamot.org> - 50.2-1
- Stable gnome-radio 50.2 with HamarRadioen for FC43

* Sun Jun 29 2025 Ole Aamot <ole@aamot.org> - 50.1-1
- Initial gnome-radio 50.1 builds on Fedora Linux 43

* Sun Jun 29 2025 Ole Aamot <ole@aamot.org> - 50.0-1
- Initial gnome-radio 50.0 builds on Fedora Linux 42

* Sun Jun 29 2025 Ole Aamot <ole@aamot.org> - 49.2-1
- Development gnome-radio 49.2 with HamarRadioen (Stange, Norge / Hamar, Norge / Ringsaker, Norge)

* Sun Jun 29 2025 Ole Aamot <ole@aamot.org> - 49.1-1
- Development gnome-radio 49.1 with HamarRadioen (Hamar-region, Norge)

* Sun Mar 02 2025 Ole Aamot <ole@aamot.org> - 49.0-1
- Initial gnome-radio 49.0 with Vermont Public Radio (Vermont, United States of America)

* Thu Feb 27 2025 Ole Aamot <ole@aamot.org> - 48.4-1
- Initial gnome-radio 48.4 with Radio 102 (Haugesund, Norway) and Radio Haugaland (Haugaland, Norway)

* Sat Feb 22 2025 Ole Aamot <ole@aamot.org> - 48.3-1
- Initial gnome-radio 48.3 with Free Internet Radio Stations

* Sat Feb 22 2025 Ole Aamot <ole@aamot.org> - 48.20250222-1
- Initial gnome-radio 48.20250222 with Free Radio Stations

* Wed Jan 22 2025 Ole Aamot <ole@aamot.org> - 48.20250122-1
- Initial gnome-radio 48.20250122 with Radio Folgefonn (Norway)

* Mon Jan 20 2025 Ole Aamot <ole@aamot.org> - 48.20250120-1
- Initial gnome-radio 48.20250120 with npr.org (United States of America)

* Wed Dec 25 2024 Ole Aamot <ole@aamot.org> - 48.1-1
- Initial gnome-radio 48.1 build with hi, is, ka, ru

* Sun Nov 03 2024 Ole Aamot <ole@aamot.org> - 48.0-1
- Initial gnome-radio 48.0 build with BBC (United Kingdom) and NRK (Norway)

* Sun Sep 25 2022 Ole Aamot <ole@gnome.org> - 47.0-1
- Initial gnome-radio 47.0 build with RBB (Frankfurt am Main, Germany)

* Mon Sep 19 2022 Ole Aamot <ole@gnome.org> - 46.0-1
- Initial gnome-radio 46.0 build with KXSC (LA, USA)

* Mon Sep 19 2022 Ole Aamot <ole@gnome.org> - 45.3-1
- Initial gnome-radio 45.3 builds with GtkEntry icon

* Sun Sep 18 2022 Ole Aamot <ole@gnome.org> - 45.2-1
- Initial gnome-radio 45.2 builds with libtool 2.4.7

* Sun Aug 14 2022 Ole Aamot <ole@gnome.org> - 45.1-1
- Initial gnome-radio 45.1 builds with Free Asia radio

* Wed Jul 20 2022 Ole Aamot <ole@gnome.org> - 45.0-1
- Initial gnome-radio 45.0 builds with GTK on Fedora 36

* Fri May 27 2022 Ole Aamot <ole@gnome.org> - 16.0.43-1
- Initial gnome-radio 16.0.43 builds on Fedora Linux 36

* Sat Apr 02 2022 Ole Aamot <ole@gnome.org> - 16.0.42-1
- Second gnome-radio 16.0.42 builds on Fedora Linux 36

* Mon Mar 28 2022 Ole Aamot <ole@gnome.org> - 16.0.6-1
- Initial gnome-radio 16.0.6 builds on Fedora Linux 36

* Mon Mar 28 2022 Ole Aamot <ole@gnome.org> - 16.0.5-1
- Initial gnome-radio 16.0.5 builds on Fedora Linux 35

* Sat Mar 19 2022 Ole Aamot <ole@gnome.org> - 16.0.4-1
- Initial gnome-radio 16.0.4 builds on Fedora Linux 36

* Tue Mar 15 2022 Ole Aamot <ole@gnome.org> - 14.0.1-1
- Initial gnome-radio 14.0.1 builds on Fedora Linux 35
