#include <config.h>
#include <gtk/gtk.h>
#include <gst/player/player.h>
#include <champlain/champlain.h>
#include <math.h>
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include "gnome-radio-file.h"
#include "gnome-radio-vosc.h"
#define RADIO_MARKER_SIZE 10

#if 0
static void
radio_window_init (RadioWindow *window)
{
	gtk_widget_init_template (GTK_WIDGET (window));
}

static void
radio_window_class_init (RadioWindowClass *class)
{
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (class),
						     "/org/gtk/gnome-radio/window.ui");
}

static void
search_text_changed (GtkEntry *entry, RadioWindow *window)
{
	RadioWindow *priv;
	const gchar *text;
	GtkWidget *tab;
	GtkWidget *view;
	GtkTextBuffer *buffer;
	GtkTextIter start, match_start, match_end;
	text = gtk_entry_get_text (entry);
	if (text[0] == '\0')
		return;
	priv = radio_window_get_instance_private (window);
	tab = gtk_stack_get_visible_child (GTK_STACK (priv->stack));
	view = gtk_bin_get_child (GTK_BIN (tab));
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (view));
	/* Very simple-minded search implementation */
	gtk_text_buffer_get_start_iter (buffer, &start);
	if (gtk_text_iter_forward_search (&start, text, GTK_TEXT_SEARCH_CASE_INSENSITIVE,
					  &match_start, &match_end, NULL))
	{
		gtk_text_buffer_select_range (buffer, &match_start, &match_end);
		gtk_text_view_scroll_to_iter (GTK_TEXT_VIEW (view), &match_start,
					      0.0, FALSE, 0.0, 0.0);
	}
}

static void
init_radio_window (RadioWindow *window) {
	gtk_widget_class_bind_template_callback (GTK_WIDGET_CLASS (class), radio_search_changed);
}
#endif

/*
  gnome-radio draws the radio_marker wth Cairo composed of 1 static
  filled circle and 1 stroked circle animated as echo.
 */
static ClutterActor *
create_radio_marker (void)
{
	ClutterActor *radio_marker;
	ClutterActor *bg;
	ClutterTimeline *timeline;
	cairo_t *cr;
	/* Create the marker */
	radio_marker = champlain_custom_marker_new ();
	/* Static filled circle ------------------------------------------ */
	bg = clutter_cairo_texture_new (RADIO_MARKER_SIZE, RADIO_MARKER_SIZE);
	cr = clutter_cairo_texture_create (CLUTTER_CAIRO_TEXTURE (bg));
	cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
	cairo_paint(cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
	/* Draw the circle */
	cairo_set_source_rgb (cr, 0, 0, 0);
	cairo_arc (cr, RADIO_MARKER_SIZE / 2.0,
		   RADIO_MARKER_SIZE / 2.0,
		   RADIO_MARKER_SIZE / 2.0, 0, 2 * M_PI);
	cairo_close_path (cr);
	/* Fill the circle */
	cairo_set_source_rgba (cr, 0.1, 0.9, 0.1, 1.0);
	cairo_fill (cr);
	cairo_destroy (cr);
	/* Add the circle to the radio_marker */
	clutter_container_add_actor (CLUTTER_CONTAINER (radio_marker), bg);
	clutter_actor_set_anchor_point_from_gravity (bg, CLUTTER_GRAVITY_CENTER);
	clutter_actor_set_position (bg, 0, 0);
	/* Echo circle ----------------------------------------------- */
	bg = clutter_cairo_texture_new (2 * RADIO_MARKER_SIZE,
					2 * RADIO_MARKER_SIZE);
	cr = clutter_cairo_texture_create (CLUTTER_CAIRO_TEXTURE (bg));
	/* Draw the circle */
	cairo_set_source_rgb (cr, 0, 0, 0);
	cairo_arc (cr, RADIO_MARKER_SIZE, RADIO_MARKER_SIZE,
		   0.9 * RADIO_MARKER_SIZE, 0, 2 * M_PI);
	cairo_close_path (cr);
	/* Stroke the circle */
	cairo_set_line_width (cr, 2.0);
	cairo_set_source_rgba (cr, 0.1, 0.7, 0.1, 1.0);
	cairo_stroke (cr);
	cairo_destroy (cr);
	/* Add the circle to the radio_marker */
	clutter_container_add_actor (CLUTTER_CONTAINER (radio_marker), bg);
	clutter_actor_lower_bottom (bg); /* Ensure it is under the previous circle */
	clutter_actor_set_position (bg, 0, 0);
	clutter_actor_set_anchor_point_from_gravity (bg,
						     CLUTTER_GRAVITY_CENTER);
	/* Animate the echo circle */
	timeline = clutter_timeline_new (1000);
	clutter_timeline_set_loop (timeline, TRUE);
	clutter_actor_set_opacity (CLUTTER_ACTOR (bg), 255);
	clutter_actor_set_scale (CLUTTER_ACTOR (bg), 0.5, 0.5);
	clutter_actor_animate_with_timeline (CLUTTER_ACTOR (bg),
					     CLUTTER_EASE_OUT_SINE,
					     timeline,
					     "opacity", 0,
					     "scale-x", 2.0,
					     "scale-y", 2.0,
					     NULL);
	clutter_timeline_start (timeline);
	return radio_marker;
}

double lat = 21.293352;
double lon = -157.839583;

typedef struct
{
	ChamplainView *view;
	ChamplainMarker *radio_marker;
} GpsCallbackData;

typedef struct
{
        RadioOscilloscope *oscilloscope_visual;
} OscilloscopeCallbackData;

static gboolean
gps_callback (GpsCallbackData *data)
{
	champlain_view_center_on (data->view, lat, lon);
	champlain_location_set_location (CHAMPLAIN_LOCATION (data->radio_marker), lat, lon);
	return TRUE;
}

gint
main (gint argc, gchar **argv)
{
	GstPlayer *player;
	GtkWidget *window;
	ChamplainView *view;
	ClutterActor *actor, *radio_oscilloscope, *radio_marker, *oscilloscope_visual, *stage;
	ChamplainMarkerLayer *layer;
	RadioInfo *radioinfo;	
	GpsCallbackData callback_data;
	/* OscilloscopeCallbackData oscilloscope_data; */
	/* VOSCWindow *vosc; */
	if (clutter_init (&argc, &argv) != CLUTTER_INIT_SUCCESS)
		return 1;
	/* vosc = (VOSCWindow *)g_new0(VOSCWindow, 1); */
	stage = clutter_stage_new ();
	clutter_stage_set_title (stage, g_strconcat("GNOME Radio", " ", VERSION, " - ", "http://www.gnomeradio.org/", " - ", "https://wiki.gnome.org/Apps/Radio", NULL));
	clutter_actor_set_size (stage, 800, 600);
	g_signal_connect (stage, "destroy", G_CALLBACK (clutter_main_quit), NULL);
	/* Create the map view */
	actor = champlain_view_new ();
	clutter_actor_set_size (CLUTTER_ACTOR (actor), 800, 600);
	clutter_container_add_actor (CLUTTER_CONTAINER (stage), actor);
	/* Create the radio_marker layer */
	layer = champlain_marker_layer_new_full (CHAMPLAIN_SELECTION_SINGLE);
	clutter_actor_show (CLUTTER_ACTOR (layer));
	champlain_view_add_layer (CHAMPLAIN_VIEW (actor), CHAMPLAIN_LAYER (layer));
	/* Create a radio_marker */
	radio_marker = create_radio_marker ();
	champlain_marker_layer_add_marker (layer, CHAMPLAIN_MARKER (radio_marker));
	/* Create a oscilloscope_visual */
	/* oscilloscope_visual = create_oscilloscope_visual (); */
        /* gnome_radio_add_visual_oscilloscope (layer, GNOME_RADIO_MARKER (oscilloscope_visual)); */
	/* Finish initialising the map view */
	g_object_set (G_OBJECT (actor), "zoom-level", 1,
		      "kinetic-mode", TRUE, NULL);
	champlain_view_center_on (CHAMPLAIN_VIEW (actor), lat, lon);
	/* Create callback that updates the map periodically */
	callback_data.view = CHAMPLAIN_VIEW (actor);
	callback_data.radio_marker = CHAMPLAIN_MARKER (radio_marker);
	/* oscilloscope_data.view = GNOME_RADIO_VIEW (radio_oscilloscope); */
        /* oscilloscope_data.oscilloscope_visual = GNOME_RADIO_MARKER (oscilloscope_visual); */
	/* Create the radio player */
	player = gst_player_new (NULL, gst_player_g_main_context_signal_dispatcher_new(NULL));
	/* gnome_radio_file_loader (radioinfo, "gnome-radio.xml"); */
	gst_player_set_uri (GST_PLAYER (player), "http://khpr-ice.streamguys1.com:80/khpr2");
	gst_player_stop (GST_PLAYER (player));
	/* Visual Oscillator */
        /* vosc->window = gtk_window_new (GTK_WINDOW_TOPLEVEL); */
        /* gtk_widget_show_all (vosc->window); */
        /* gnome_radio_real(GST_PLAYER (player), CLUTTER_ACTOR (radio_oscilloscope)); */
        /* clutter_container_add_actor (CLUTTER_CONTAINER (stage), CLUTTER_ACTOR (radio_oscilloscope)); */
	gst_player_play(GST_PLAYER (player));
	g_timeout_add (1000, (GSourceFunc) gps_callback, &callback_data);
	/* g_timeout_add (1000, (GSourceFunc) gnome_radio_real, &oscilloscope_data); */
	clutter_actor_show (stage);
        /* clutter_actor_show (radio_oscilloscope); */
	clutter_main ();
	return (0);
}
